function [varargout]=matricesdivP2P12D
% MATRICESDIVP2P12D local divergence matrices for the (P2,P1) 
% mixed 2D elements.
%   [DIVX,DIVY]=MATRICESDIVP2P12D computes the following local matrices: 
%
%   DIVX = (DIVX(I,J)) = - (Int(Tref) psi_J * d(phi_I)/dx dT),  
%   DIVY = (DIVY(I,J)) = - (Int(Tref) psi_J * d(phi_I)/dy dT).
%
% where psi_J is the J-th basis function of the P1 finite elements
% space and phi_I the I-th of the P2 finite elements space.

%      

varargout(1) = {[ 1/6  0    0;  ...
                  0   -1/6  0;  ...
                  0    0    0;  ...
                 -1/6  1/6  0;  ...
                 -1/6 -1/6 -1/3;...
		  1/6  1/6  1/3]};
varargout(2) = {[ 1/6  0    0;  ...
                  0    0    0;  ...
                  0    0   -1/6;...
                  1/6  1/3  1/6;...
                 -1/6 -1/3 -1/6;...
		 -1/6  0    1/6]};
                                         
return
